
#ifndef _BC7262_H_
#define _BC7262_H_

#include "typedef.h"
#include "bc7262reg.h"
#include "parameter.h"
#include "ble_adv.h"

enum
{
	DEEP_SLEEP = 0,
	LIGHT_SLEEP,
	RX_MODE,
	TX_MODE,
	TRT_MODE,
	RTR_MODE,
};

void BC7262_InterfaceConfigure(void);
void BC7262_WakeUp(void);
void BC7262_ParameterInitial(void);
void BC7262_Calibration(u8 reg, u8 val);
void BC7262_inital(void);

u8 BC7262_mode(void);
void BC7262_TxPower(u8 txp);

irq_t BC7262_ClrIrq(void);
void BC7262_DeepSleep(void);
void BC7262_LightSleep(void);

void BC7262_WritePDUFIFO(u8 *pdu,u8 len);
void BC7262_ReadPDUFIFO(adv_pdu_struct *adv,u8 fifo,u8 pdud);
void BC7262_WriteHeader(u8 reg, u8 *hdr);
void BC7262_WriteAccAddr(u8 *addr);

u8 	BC7262_ReadRegister(u8 adr,u8 *rval);
u8 	BC7262_ReadMultiRegister(u8 adr,u8 *rval,u8 leng);
u8 	BC7262_WriteRegister(u8 adr,u8 val);
u8 	BC7262_WriteMultiRegister(u8 adr,u8 *val,u8 leng);

#define	BC7262_WriteDevAddr(pdu)		BC7262_WriteMultiRegister(DEV_ADDR_0_REG, pdu, 6)
#define	BC7262_WriteWhtAddr(pdu)		BC7262_WriteMultiRegister(WL_ADDR_0_REG, pdu, 6)

#define	BC7262_TXAdvStart(advch)		BC7262_WriteRegister(TRX_CTL_REG,advch | 0x10)
	
#define	BC7262_RXAdvStart(advch)		BC7262_WriteRegister(TRX_CTL_REG,advch | 0x20)
#define	BC7262_TRTAdvStart(advch)		BC7262_WriteRegister(TRX_CTL_REG,advch | 0x90)
#define	BC7262_RTRAdvStart(advch)		BC7262_WriteRegister(TRX_CTL_REG,advch | 0xA0)

#define BC7262_WhtFilter(wht_flt)		BC7262_WriteRegister(WL_CTL_REG, wht_flt)
	
#define BC7262_AdvStop(advch)           BC7262_WriteRegister(TRX_CTL_REG,advch)  

#define BC7262_LircCal()				BC7262_Calibration(LIRC_CTL_REG, 0x80)
#define BC7262_TPCal()					BC7262_Calibration(TPCAL_REG, 0x01)
#define BC7262_RCCal()					BC7262_Calibration(RC_CAL_REG, 0x01)
#define BC7262_VCOCal()					BC7262_Calibration(VCOCAL_REQ, 0x01)

#endif   /* _BC7262_H_ */
